<?php
// Cargar WordPress
require_once(__DIR__ . '/../../../wordpress/wp-load.php');
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Escuela Profesional de Ingenieria Agroindustrial - Facultad de Ingenieria Agroindustrial - UNSM">
    <meta name="keywords" content="UNSM, Ingenieria Agroindustrial, Agroindustria, Universidad San Martin, Procesamiento de Alimentos">
    <meta name="author" content="Universidad Nacional de San Martin">
    <meta name="robots" content="index, follow">
    <meta name="theme-color" content="#359444">

    <title>Escuela de Ingenieria Agroindustrial - UNSM</title>

    <!-- Favicon -->
    <link rel="icon" type="image/png" href="../../../imagenes/escudo unsm.png" sizes="48x48">

    <!-- Stylesheet Principal -->
    <link rel="stylesheet" href="../../../css/style.css">
    <!-- Stylesheet Ingenieria Agroindustrial Facultad -->
    <link rel="stylesheet" href="../css/styleIngAgroIndus.css">
    <!-- Stylesheet Ingenieria Agroindustrial Escuela -->
    <link rel="stylesheet" href="css/styleAgroIn.css?v=1.0">
</head>
<body>
    <!-- Header Superior -->
    <header class="top-header" role="banner">
        <div class="top-header-content">
            <nav class="social-icons" aria-label="Redes sociales">
                <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en Facebook" aria-label="Pagina oficial de Facebook de la UNSM">
                    <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="36" height="36">
                </a>
                <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" title="Siguenos en Instagram" aria-label="Perfil oficial de Instagram de la UNSM">
                    <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="36" height="36">
                </a>
                <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" title="Visita nuestro canal de YouTube" aria-label="Canal oficial de YouTube de la UNSM">
                    <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="36" height="36">
                </a>
                <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" title="Siguenos en X (Twitter)" aria-label="Cuenta oficial de X de la UNSM">
                    <img src="../../../imagenes/redes/logo x.png" alt="X (Twitter)" width="36" height="36">
                </a>
                <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" title="Siguenos en TikTok" aria-label="Perfil oficial de TikTok de la UNSM">
                    <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="36" height="36">
                </a>
            </nav>
            <div class="contact-info">
                <span>
                    <img src="../../../imagenes/logo telefono.png" alt="Telefono" class="contact-icon" width="18" height="18">
                    <span>(+51) (042) 52-4253</span>
                </span>
                <span>
                    <img src="../../../imagenes/logo correo.png" alt="Correo" class="contact-icon" width="18" height="18">
                    <span>fia@unsm.edu.pe</span>
                </span>
            </div>
        </div>
    </header>

    <!-- Header Principal -->
    <header class="main-header">
        <div class="main-header-content">
            <div class="logo">
                <a href="../../../" aria-label="Ir a la pagina principal de UNSM">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo de la Universidad Nacional de San Martin" width="auto" height="70">
                </a>
            </div>

            <!-- Boton Hamburguesa para movil -->
            <button class="mobile-menu-toggle" aria-label="Abrir menu de navegacion" aria-expanded="false" aria-controls="main-navigation">
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
                <span aria-hidden="true"></span>
            </button>

            <nav class="main-nav" id="main-navigation" aria-label="Navegacion principal">
                <div class="mobile-nav-logo">
                    <img src="../../../imagenes/logo UNSM.png" alt="Logo UNSM" width="auto" height="65">
                </div>

                <ul class="nav-menu">
                    <li class="dropdown">
                        <a href="#nosotros" aria-haspopup="true" aria-expanded="false">NOSOTROS</a>
                        <ul class="dropdown-menu" aria-label="Menu Nosotros">
                            <li><a href="../../../nosotros/autoridades/indexAuto.php">Autoridades</a></li>
                            <li><a href="../../../nosotros/historia/historia.php">Historia de la Universidad</a></li>
                            <li><a href="../../../nosotros/mision/indexMision.php">Nuestra Mision y Vision</a></li>
                            <li><a href="../../../nosotros/objetivos/objeIndex.php">Objetivos</a></li>
                            <li><a href="../../../nosotros/onigrama/indexOni.php">Organigrama</a></li>
                            <li><a href="../../../nosotros/himno/indexHimno.php">Himno</a></li>
                            <li><a href="../../../nosotros/directorioInstucional/indexDirec.php">Directorio Institucional</a></li>
                            <li><a href="../../../nosotros/calendarioAcade/indexCale.php">Calendario Academico</a></li>
                        </ul>
                    </li>
                    <li class="dropdown dropdown-wide">
                        <a href="#oficinas" aria-haspopup="true" aria-expanded="false">OFICINAS</a>
                        <ul class="dropdown-menu dropdown-columns" aria-label="Menu Oficinas">
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Administrativas</li>
                                <li><a href="../../../oficinas/rectorado/indexRecto.php">Rectorado</a></li>
                                <li><a href="../../../oficinas/vicerrectorado academico/indexVicerec.php">Vicerrectorado Academico</a></li>
                                <li><a href="../../../oficinas/vicerrectorado de investigacion/indexViceRecAca.php">Vicerrectorado de Investigacion</a></li>
                                <li><a href="../../../oficinas/secretaria general/indexSecreGene.php">Secretaria General</a></li>
                                <li><a href="../../../oficinas/planeamiento y presupuesto/indexPlanea.php">Planeamiento y Presupuesto</a></li>
                                <li><a href="../../../oficinas/seguridad y salud ocupacional/indexSeguri.php">Seguridad y Salud Ocupacional</a></li>
                                <li><a href="../../../oficinas/comunicacion y imagen institucional/indexImagen.php">Comunicacion e Imagen Institucional</a></li>
                                <li><a href="../../../oficinas/Cooperacion y Relaciones Internacionales/indexCoopera.php">Cooperacion y Relaciones Internacionales</a></li>
                                <li><a href="../../../oficinas/Organo de Control Institucional/indexOrgaConIns.php">Organo de Control Institucional</a></li>
                                <li><a href="../../../oficinas/Ejecutora de Inversiones/indexEjec.php">Ejecutora de Inversiones</a></li>
                                <li><a href="../../../oficinas/Asesoria Juridica/indexAseJuri.php">Asesoria Juridica</a></li>
                                <li><a href="../../../oficinas/Grados y Titulos/indexGrados.php">Grados y Titulos</a></li>
                            </div>
                            <div class="dropdown-column">
                                <li class="dropdown-header">Oficinas Academicas</li>
                                <li><a href="../../../oficinas/Academicos/OFICINA DE ADMISION/indexOfiAdmin.php">Oficina de Admision</a></li>
                                <li><a href="../../../oficinas/Academicos/ASUNTOS ACADEMICOS/indexAsunAca.php">Asuntos Academicos</a></li>
                                <li><a href="../../../oficinas/Academicos/Seguimiento al Egresado e Insercion Laboral/indexSegui.php">Seguimiento al Egresado e Insercion Laboral</a></li>
                                <li><a href="../../../oficinas/Academicos/TECNOLOGIAS DE LA INFORMACION/indexOTI.php">Tecnologias de la Informacion</a></li>
                                <li><a href="../../../oficinas/Academicos/INCUBADORA DE EMPRESAS/indexIncu.php">Incubadora de Empresas</a></li>
                                <li><a href="../../../oficinas/Academicos/FONDO EDITORIAL/indexFondo.php">Fondo Editorial</a></li>
                                <li><a href="../../../oficinas/Academicos/COMITE ELECTORAL UNIVERSITARIO/indexComite.php">Comite Electoral Universitario</a></li>
                                <li><a href="../../../oficinas/Academicos/INNOVACION Y TRANSFERENCIA TECNOLOGICA/indexInno.php">Innovacion y Transferencia Tecnologica</a></li>
                            </div>
                        </ul>
                    </li>
                    <li><a href="../../../admision/indexAdmin.php">ADMISION</a></li>
                    <li><a href="../../../#cpu">CPU</a></li>
                    <li class="dropdown dropdown-facultades">
                        <a href="../../../#facultades" aria-haspopup="true" aria-expanded="false">FACULTADES</a>
                        <ul class="dropdown-menu" aria-label="Menu Facultades">
                            <li class="has-submenu">
                                <a href="../../ciencias agrarias/indexAgra.php" aria-haspopup="true" aria-expanded="false">Ciencias Agrarias</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Agrarias">
                                    <li><a href="../../ciencias agrarias/agronomia/indexAgro.php">Agronomia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../ciencias de la salud/indexSalud.php" aria-haspopup="true" aria-expanded="false">Ciencias de la Salud</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias de la Salud">
                                    <li><a href="../../ciencias de la salud/OBSTETRICIA/indexObst.php">Obstetricia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../medicina veterinaria/indexVet.php" aria-haspopup="true" aria-expanded="false">Medicina Veterinaria</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Veterinaria">
                                    <li><a href="../../medicina veterinaria/veterinaria/indexMedVet.php">Medicina Veterinaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../indexIngAgroIndus.php" aria-haspopup="true" aria-expanded="false">Ingenieria Agroindustrial</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Agroindustrial">
                                    <li><a href="indexAgroIn.php">Ingenieria Agroindustrial</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../Ingenieria civil y arquitectura/indexCivArq.php" aria-haspopup="true" aria-expanded="false">Ingenieria Civil y Arquitectura</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria Civil y Arquitectura">
                                    <li><a href="#arquitectura">Arquitectura</a></li>
                                    <li><a href="#ingenieria-civil-carrera">Ingenieria Civil</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../Ingenieria de sistemas e informatica/indexFisi.php" aria-haspopup="true" aria-expanded="false">Ingenieria de Sistemas e Informatica</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ingenieria de Sistemas">
                                    <li><a href="#ing-sistemas">Ingenieria de Sistemas e Informatica</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../ecologia/indexEcolo.php" aria-haspopup="true" aria-expanded="false">Ecologia</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ecologia">
                                    <li><a href="#ing-ambiental">Ingenieria Ambiental</a></li>
                                    <li><a href="#ing-sanitaria">Ingenieria Sanitaria</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../derecho y ciencias politicas/indexDerePoli.php" aria-haspopup="true" aria-expanded="false">Derecho y Ciencias Politicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Derecho">
                                    <li><a href="#derecho-carrera">Derecho</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../medicina humana/indexMed.php" aria-haspopup="true" aria-expanded="false">Medicina Humana</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Medicina Humana">
                                    <li><a href="#medicina-humana-carrera">Medicina Humana</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../educacion y humanidades/indexEdu.php" aria-haspopup="true" aria-expanded="false">Educacion y Humanidades</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Educacion">
                                    <li><a href="#educacion-inicial">Educacion Inicial</a></li>
                                    <li><a href="#educacion-primaria">Educacion Primaria</a></li>
                                    <li><a href="#educacion-secundaria">Educacion Secundaria</a></li>
                                    <li><a href="../../educacion y humanidades/psicologia/indexPsico.php">Psicologia</a></li>
                                </ul>
                            </li>
                            <li class="has-submenu">
                                <a href="../../ciencias economicas/indexCienEco.php" aria-haspopup="true" aria-expanded="false">Ciencias Economicas</a>
                                <ul class="submenu-carreras" aria-label="Carreras de Ciencias Economicas">
                                    <li><a href="#administracion">Administracion</a></li>
                                    <li><a href="#economia">Economia</a></li>
                                    <li><a href="#contabilidad">Contabilidad</a></li>
                                </ul>
                            </li>
                        </ul>
                    </li>
                    <li><a href="../../../#posgrado">POSGRADO</a></li>
                    <li><a href="../../../#transparencia">TRANSPARENCIA</a></li>
                </ul>

                <div class="mobile-nav-gob-logos">
                    <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia de la UNSM">
                        <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" width="auto" height="35">
                    </a>
                    <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Portal del Gobierno del Peru">
                        <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" width="auto" height="35">
                    </a>
                </div>
            </nav>

            <div class="gob-logos">
                <a href="https://www.gob.pe/unsm" target="_blank" rel="noopener noreferrer" aria-label="Portal de Transparencia">
                    <img src="../../../imagenes/logo portal de trans.png" alt="Portal de Transparencia" class="portal-trans-logo" width="auto" height="32">
                </a>
                <a href="https://www.gob.pe" target="_blank" rel="noopener noreferrer" aria-label="Gobierno del Peru">
                    <img src="../../../imagenes/logo gobPe.png" alt="Gobierno del Peru" class="gob-logo" width="auto" height="30">
                </a>
            </div>
        </div>
    </header>

    <!-- Banner Ingenieria Agroindustrial -->
    <section class="agroin-banner">
        <div class="banner-image">
            <img src="../img/banner-agroindustrial.jpg" alt="Profesional en planta agroindustrial">
        </div>
        <div class="banner-overlay"></div>
        <div class="banner-content-wrapper">
            <div class="banner-header">
                <div class="banner-logo">
                    <img src="../../../imagenes/Escudos de Facultades — UNSM/FIAI-UNSM-2021.png" alt="Logo Facultad de Ingenieria Agroindustrial" width="80" height="80">
                </div>
                <div class="banner-title-section">
                    <h1>ESCUELA DE INGENIERIA AGROINDUSTRIAL</h1>
                    <p class="banner-breadcrumb">📍 Facultad de Ingenieria Agroindustrial</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Seccion Escuela con Sidebar -->
    <section class="escuela-section">
        <div class="escuela-container">
            <!-- Contenido Principal -->
            <div class="escuela-main-content">
                <div class="section-badge">
                    <span class="badge-circle">LA</span>
                    <h2 class="section-title">ESCUELA</h2>
                </div>

                <div class="escuela-content">
                    <p>La Escuela de Ingenieria Agroindustrial de la Universidad Nacional de San Martin-Tarapoto, forma profesionales competitivos con solida formacion cientifica, tecnologica y humanistica, capaces de disenar, implementar y gestionar sistemas agroindustriales sostenibles.</p>
                    <p>El Ingeniero Agroindustrial de la UNSM esta capacitado para transformar materias primas de origen agropecuario en productos con valor agregado, aplicando tecnologias innovadoras y respetando los estandares de calidad e inocuidad alimentaria, contribuyendo al desarrollo economico de la region amazonica y del pais.</p>
                </div>
            </div>

            <!-- Sidebar de Eventos -->
            <aside class="eventos-sidebar">
                <div class="eventos-container">
                    <h3>Proximos Eventos</h3>
                    <p class="no-eventos">No hay nuevos eventos.</p>
                    <div class="eventos-actions">
                        <button class="btn-add">Anadir</button>
                        <a href="#" class="btn-calendar">Ver Calendario &#9654;</a>
                    </div>

                    <div class="contactenos-box">
                        <h4>Contactenos</h4>
                        <p><strong>Campus principal:</strong></p>
                        <p>Jr. Maynas N. 177 - Tarapoto - Peru</p>
                        <p><strong>Telefono:</strong> (+51) (042) 52-4253</p>
                        <p><strong>Email:</strong> fia@unsm.edu.pe</p>
                        <p><strong>Horario:</strong> Lunes a Viernes 7:00am a 2:30pm</p>
                    </div>
                </div>
            </aside>
        </div>
    </section>

    <!-- Seccion Carrera Profesional -->
    <section class="carrera-section">
        <div class="carrera-container">
            <div class="carrera-header">
                <h2>CARRERA PROFESIONAL: INGENIERIA AGROINDUSTRIAL</h2>
            </div>

            <div class="carrera-content-wrapper">
                <!-- Menu Lateral -->
                <div class="carrera-sidebar">
                    <ul class="sidebar-menu">
                        <li><a href="#mision" class="sidebar-link active" data-section="mision">MISION</a></li>
                        <li><a href="#objetivos" class="sidebar-link" data-section="objetivos">OBJETIVOS EDUCACIONALES</a></li>
                        <li><a href="#perfil" class="sidebar-link" data-section="perfil">PERFIL PROFESIONAL</a></li>
                        <li><a href="#aptitudes" class="sidebar-link" data-section="aptitudes">APTITUDES REQUERIDAS</a></li>
                        <li><a href="#ingreso" class="sidebar-link" data-section="ingreso">PERFIL DE INGRESO</a></li>
                        <li><a href="#campo" class="sidebar-link" data-section="campo">CAMPO LABORAL</a></li>
                        <li><a href="#malla" class="sidebar-link" data-section="malla">MALLA CURRICULAR</a></li>
                        <li><a href="#especializacion" class="sidebar-link" data-section="especializacion">AREA DE ESPECIALIZACION</a></li>
                        <li><a href="#grados" class="sidebar-link" data-section="grados">GRADOS</a></li>
                        <li><a href="#duracion" class="sidebar-link" data-section="duracion">DURACION DE LA CARRERA</a></li>
                        <li><a href="#resultados" class="sidebar-link" data-section="resultados">RESULTADOS DEL ESTUDIANTE</a></li>
                        <li><a href="#matricula" class="sidebar-link" data-section="matricula">MATRICULA ANUAL</a></li>
                        <li><a href="#docentes" class="sidebar-link" data-section="docentes">DOCENTES</a></li>
                        <li><a href="#egresados" class="sidebar-link" data-section="egresados">EGRESADOS</a></li>
                        <li><a href="#graduados" class="sidebar-link" data-section="graduados">GRADUADOS</a></li>
                        <li><a href="#laboratorios" class="sidebar-link" data-section="laboratorios">LABORATORIOS</a></li>
                        <li><a href="#documentos" class="sidebar-link" data-section="documentos">DOCUMENTOS DE GESTION</a></li>
                        <li><a href="#convocatorias" class="sidebar-link" data-section="convocatorias">CONVOCATORIAS</a></li>
                    </ul>
                </div>

                <!-- Contenido Principal -->
                <div class="carrera-main">
                    <div class="carrera-section-content active" id="mision">
                        <h3>MISION DEL PROGRAMA DE ESTUDIOS</h3>
                        <p>Somos una escuela acreditada, formadora de profesionales competitivos y emprendedores, con valores, principios eticos, comprometidos con el desarrollo sostenible de la agroindustria en la region y el pais, con responsabilidad social y ambiental.</p>
                        <p>Nuestro compromiso es formar ingenieros agroindustriales con capacidad de liderazgo, innovacion y emprendimiento, preparados para enfrentar los retos del sector agroindustrial en un contexto globalizado.</p>
                    </div>

                    <div class="carrera-section-content" id="objetivos">
                        <h3>OBJETIVOS EDUCACIONALES</h3>
                        <p>Los objetivos educacionales del Programa de Estudios de Ingenieria Agroindustrial son:</p>
                        <ul class="perfil-list">
                            <li>Formar profesionales competentes en el diseño, implementacion y gestion de procesos agroindustriales sostenibles.</li>
                            <li>Desarrollar capacidades de investigacion e innovacion tecnologica para la solucion de problemas del sector agroindustrial.</li>
                            <li>Promover el emprendimiento y la gestion empresarial en el sector agroindustrial.</li>
                            <li>Fomentar valores eticos, responsabilidad social y compromiso con el desarrollo sostenible.</li>
                            <li>Contribuir al desarrollo economico regional y nacional mediante la transformacion de materias primas agropecuarias.</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="perfil">
                        <h3>PERFIL PROFESIONAL</h3>
                        <p>El Ingeniero Agroindustrial egresado de la UNSM es un profesional con solida formacion cientifica, tecnologica y humanistica, capaz de:</p>
                        <ul class="perfil-list">
                            <li>Disenar, implementar y gestionar procesos agroindustriales sostenibles</li>
                            <li>Transformar materias primas agropecuarias en productos con valor agregado</li>
                            <li>Aplicar tecnologias innovadoras en el procesamiento de alimentos</li>
                            <li>Gestionar sistemas de calidad e inocuidad alimentaria</li>
                            <li>Desarrollar proyectos de investigacion e innovacion tecnologica</li>
                            <li>Liderar equipos de trabajo multidisciplinarios</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="aptitudes">
                        <h3>APTITUDES REQUERIDAS</h3>
                        <p>El estudiante de Ingenieria Agroindustrial debe desarrollar las siguientes aptitudes:</p>
                        <ul class="perfil-list">
                            <li>Capacidad de analisis y sintesis de informacion tecnica y cientifica</li>
                            <li>Habilidad para resolver problemas complejos de ingenieria</li>
                            <li>Capacidad de trabajo en equipo y liderazgo</li>
                            <li>Comunicacion efectiva oral y escrita</li>
                            <li>Pensamiento critico e innovador</li>
                            <li>Compromiso con el aprendizaje continuo</li>
                            <li>Responsabilidad social y ambiental</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="ingreso">
                        <h3>PERFIL DE INGRESO</h3>
                        <p>El postulante a la carrera de Ingenieria Agroindustrial debe poseer las siguientes caracteristicas:</p>
                        <ul class="perfil-list">
                            <li>Interes por las ciencias basicas: matematicas, fisica, quimica y biologia</li>
                            <li>Vocacion por la investigacion e innovacion tecnologica</li>
                            <li>Capacidad de analisis y resolucion de problemas</li>
                            <li>Interes por el sector agroindustrial y alimentario</li>
                            <li>Compromiso con el desarrollo sostenible y el medio ambiente</li>
                            <li>Habilidades para el trabajo en equipo</li>
                            <li>Disposicion para el aprendizaje continuo</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="campo">
                        <h3>CAMPO LABORAL</h3>
                        <p>El Ingeniero Agroindustrial puede desempenarse en diversos sectores:</p>
                        <ul class="campo-list">
                            <li>Industrias de procesamiento de alimentos y bebidas</li>
                            <li>Plantas de procesamiento de productos agricolas</li>
                            <li>Empresas de control de calidad e inocuidad alimentaria</li>
                            <li>Laboratorios de analisis de alimentos</li>
                            <li>Instituciones de investigacion y desarrollo tecnologico</li>
                            <li>Empresas de consultoria agroindustrial</li>
                            <li>Organismos de certificacion y normalizacion</li>
                            <li>Sector publico (MINAGRI, SENASA, PRODUCE)</li>
                            <li>Docencia universitaria e investigacion</li>
                            <li>Emprendimiento de negocios agroindustriales propios</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="malla">
                        <h3>MALLA CURRICULAR</h3>
                        <p>La malla curricular de la carrera de Ingenieria Agroindustrial esta disenada para formar profesionales integrales con solidos conocimientos en ciencias basicas, ciencias de la ingenieria y especialidad agroindustrial.</p>
                        <p>El plan de estudios comprende asignaturas de formacion general, formacion basica, formacion profesional y actividades complementarias distribuidas en 10 semestres academicos.</p>
                        <a href="#" class="btn-download">📄 Descargar Malla Curricular (PDF)</a>
                    </div>

                    <div class="carrera-section-content" id="especializacion">
                        <h3>AREA DE ESPECIALIZACION</h3>
                        <p>La Escuela de Ingenieria Agroindustrial ofrece las siguientes areas de especializacion:</p>
                        <ul class="campo-list">
                            <li>Tecnologia de Alimentos</li>
                            <li>Control de Calidad e Inocuidad Alimentaria</li>
                            <li>Procesos Agroindustriales</li>
                            <li>Gestion y Emprendimiento Agroindustrial</li>
                            <li>Biotecnologia Agroindustrial</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="grados">
                        <h3>GRADOS</h3>
                        <div class="info-cards-grid">
                            <div class="info-card">
                                <div class="info-icon">📚</div>
                                <div class="info-details">
                                    <h4>GRADO ACADEMICO</h4>
                                    <p>Bachiller en Ingenieria Agroindustrial</p>
                                </div>
                            </div>
                            <div class="info-card">
                                <div class="info-icon">🎓</div>
                                <div class="info-details">
                                    <h4>TITULO PROFESIONAL</h4>
                                    <p>Ingeniero Agroindustrial</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="carrera-section-content" id="duracion">
                        <h3>DURACION DE LA CARRERA</h3>
                        <div class="info-cards-grid">
                            <div class="info-card">
                                <div class="info-icon">📅</div>
                                <div class="info-details">
                                    <h4>DURACION</h4>
                                    <p>10 semestres academicos (5 años)</p>
                                </div>
                            </div>
                            <div class="info-card">
                                <div class="info-icon">📋</div>
                                <div class="info-details">
                                    <h4>MODALIDAD</h4>
                                    <p>Presencial</p>
                                </div>
                            </div>
                            <div class="info-card">
                                <div class="info-icon">📝</div>
                                <div class="info-details">
                                    <h4>CREDITOS TOTALES</h4>
                                    <p>220 creditos</p>
                                </div>
                            </div>
                            <div class="info-card">
                                <div class="info-icon">📖</div>
                                <div class="info-details">
                                    <h4>ASIGNATURAS</h4>
                                    <p>55 asignaturas</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="carrera-section-content" id="resultados">
                        <h3>RESULTADOS DEL ESTUDIANTE</h3>
                        <p>Al culminar la carrera, el estudiante sera capaz de:</p>
                        <ul class="perfil-list">
                            <li>Aplicar conocimientos de matematicas, ciencias e ingenieria en la solucion de problemas agroindustriales.</li>
                            <li>Disenar y conducir experimentos, analizar e interpretar datos.</li>
                            <li>Disenar sistemas, componentes o procesos agroindustriales que satisfagan necesidades especificas.</li>
                            <li>Trabajar en equipos multidisciplinarios.</li>
                            <li>Identificar, formular y resolver problemas de ingenieria agroindustrial.</li>
                            <li>Comprender la responsabilidad etica y profesional.</li>
                            <li>Comunicarse de manera efectiva.</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="matricula">
                        <h3>MATRICULA ANUAL</h3>
                        <p>Informacion sobre el proceso de matricula:</p>
                        <ul class="campo-list">
                            <li>La matricula se realiza de manera semestral</li>
                            <li>El proceso de matricula es virtual a traves del sistema academico</li>
                            <li>Los estudiantes deben estar al dia en sus pagos</li>
                            <li>Se debe respetar los prerequisitos de las asignaturas</li>
                        </ul>
                        <a href="#" class="btn-ver-mas">Ver cronograma de matricula →</a>
                    </div>

                    <div class="carrera-section-content" id="docentes">
                        <h3>DOCENTES</h3>
                        <p>La Escuela de Ingenieria Agroindustrial cuenta con un equipo de docentes altamente calificados, con grados de maestria y doctorado en universidades nacionales e internacionales, comprometidos con la formacion de profesionales de excelencia.</p>
                        <a href="#" class="btn-ver-mas">Ver directorio de docentes →</a>
                    </div>

                    <div class="carrera-section-content" id="egresados">
                        <h3>EGRESADOS</h3>
                        <p>Nuestros egresados se desempeñan exitosamente en diversas empresas e instituciones del sector agroindustrial a nivel regional, nacional e internacional.</p>
                        <a href="#" class="btn-ver-mas">Ver directorio de egresados →</a>
                    </div>

                    <div class="carrera-section-content" id="graduados">
                        <h3>GRADUADOS</h3>
                        <p>Estadisticas de graduados de la Escuela de Ingenieria Agroindustrial:</p>
                        <a href="#" class="btn-ver-mas">Ver estadisticas de graduados →</a>
                    </div>

                    <div class="carrera-section-content" id="laboratorios">
                        <h3>LABORATORIOS</h3>
                        <p>La Escuela de Ingenieria Agroindustrial cuenta con modernos laboratorios equipados para la formacion practica de los estudiantes:</p>
                        <ul class="campo-list">
                            <li>Laboratorio de Analisis de Alimentos</li>
                            <li>Laboratorio de Microbiologia</li>
                            <li>Laboratorio de Operaciones Unitarias</li>
                            <li>Planta Piloto Agroindustrial</li>
                            <li>Laboratorio de Control de Calidad</li>
                            <li>Laboratorio de Biotecnologia</li>
                        </ul>
                    </div>

                    <div class="carrera-section-content" id="documentos">
                        <h3>DOCUMENTOS DE GESTION</h3>
                        <p>Documentos normativos y de gestion de la Escuela:</p>
                        <ul class="campo-list">
                            <li>Plan de Estudios</li>
                            <li>Reglamento Academico</li>
                            <li>Silabos de Asignaturas</li>
                            <li>Plan Estrategico</li>
                            <li>Informe de Autoevaluacion</li>
                        </ul>
                        <a href="#" class="btn-download">📄 Descargar documentos</a>
                    </div>

                    <div class="carrera-section-content" id="convocatorias">
                        <h3>CONVOCATORIAS</h3>
                        <p>Convocatorias vigentes de la Escuela de Ingenieria Agroindustrial:</p>
                        <p class="no-convocatorias">No hay convocatorias vigentes en este momento.</p>
                        <a href="#" class="btn-ver-mas">Ver historial de convocatorias →</a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Seccion Noticias Recientes -->
    <section class="noticias-section">
        <div class="noticias-container">
            <h2>ULTIMAS NOTICIAS</h2>
            <div class="noticias-grid">
                <?php
                // Obtener ultimas noticias desde WordPress
                $noticias_args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                    'orderby'        => 'date',
                    'order'          => 'DESC',
                    'post_status'    => 'publish'
                );

                $noticias_query = new WP_Query($noticias_args);

                if ($noticias_query->have_posts()) :
                    while ($noticias_query->have_posts()) : $noticias_query->the_post();
                        // Obtener categoria
                        $categorias = get_the_category();
                        $categoria_nombre = !empty($categorias) ? $categorias[0]->name : 'NOTICIA';
                ?>
                    <article class="noticia-card">
                        <div class="noticia-image">
                            <?php if (has_post_thumbnail()) : ?>
                                <?php the_post_thumbnail('medium', array('alt' => get_the_title(), 'loading' => 'lazy')); ?>
                            <?php else : ?>
                                <img src="../img/banner-agroindustrial.jpg" alt="<?php echo esc_attr(get_the_title()); ?>" loading="lazy">
                            <?php endif; ?>
                            <span class="noticia-badge"><?php echo esc_html(strtoupper($categoria_nombre)); ?></span>
                        </div>
                        <div class="noticia-content">
                            <h3><?php the_title(); ?></h3>
                            <p><?php echo wp_trim_words(get_the_excerpt(), 20, '...'); ?></p>
                            <a href="<?php the_permalink(); ?>" class="noticia-link">Leer mas →</a>
                        </div>
                    </article>
                <?php
                    endwhile;
                    wp_reset_postdata();
                else :
                ?>
                    <p class="no-noticias">No hay noticias disponibles en este momento.</p>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer role="contentinfo">
        <div class="footer-content">
            <section class="footer-section">
                <div class="footer-logo-section">
                    <img src="../../../imagenes/escudo unsm.png" alt="Escudo oficial de la UNSM" class="footer-logo" width="60" height="auto">
                    <h3 class="footer-title">UNSM</h3>
                </div>
                <p class="footer-description">Centro Superior de Estudios autonomo y de caracter estatal, comprometido con la formacion de profesionales humanistas y competitivos, con responsabilidad social y comprometidos con el desarrollo local, regional y nacional.</p>
                <address>
                    <p>Jr. Maynas N. 177 - Morales</p>
                    <p>Tarapoto - San Martin - Peru</p>
                    <p>Central Telefonica: <span>(+51) (042) 48 0153</span></p>
                    <p>Email: <span>informes@unsm.edu.pe</span></p>
                </address>
            </section>

            <nav class="footer-section" aria-labelledby="footer-links-title">
                <h3 id="footer-links-title" class="footer-title">Enlaces Rapidos</h3>
                <ul class="footer-links">
                    <li><a href="../../../admision/indexAdmin.php">Admision</a></li>
                    <li><a href="../../../index.php#facultades">Facultades</a></li>
                    <li><a href="../../../index.php#posgrado">Posgrado</a></li>
                    <li><a href="../../../index.php#investigacion">Investigacion</a></li>
                </ul>
            </nav>

            <nav class="footer-section" aria-labelledby="footer-services-title">
                <h3 id="footer-services-title" class="footer-title">Servicios</h3>
                <ul class="footer-links">
                    <li><a href="../../../index.php#biblioteca">Biblioteca Virtual</a></li>
                    <li><a href="../../../index.php#campus-virtual">Campus Virtual</a></li>
                    <li><a href="../../../index.php#repositorio">Repositorio Institucional</a></li>
                    <li><a href="../../../index.php#transparencia">Portal de Transparencia</a></li>
                    <li><a href="../../../index.php#libro-reclamaciones">Libro de Reclamaciones</a></li>
                    <li><a href="../../../contacto/indexContac.php">Enviar Mensaje</a></li>
                </ul>
            </nav>

            <section class="footer-section footer-facebook" aria-labelledby="footer-facebook-title">
                <h3 id="footer-facebook-title" class="footer-title">Facebook UNSM</h3>
                <div class="fb-page"
                    data-href="https://www.facebook.com/unsmperu"
                    data-tabs="timeline"
                    data-width="320"
                    data-height="320"
                    data-small-header="false"
                    data-adapt-container-width="true"
                    data-hide-cover="false"
                    data-show-facepile="true">
                    <blockquote cite="https://www.facebook.com/unsmperu" class="fb-xfbml-parse-ignore">
                        <a href="https://www.facebook.com/unsmperu">Universidad Nacional de San Martin - UNSM</a>
                    </blockquote>
                </div>
            </section>
        </div>

        <div class="footer-bottom">
            <div class="footer-bottom-content">
                <p>&copy; 2025 Universidad Nacional de San Martin. Todos los derechos reservados.</p>
                <div class="footer-social-bottom">
                    <span class="footer-social-title">Siguenos</span>
                    <nav class="footer-social" aria-label="Redes sociales de la UNSM">
                        <a href="https://www.facebook.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="Facebook UNSM">
                            <img src="../../../imagenes/redes/logo facebook.png" alt="Facebook" width="22" height="22">
                        </a>
                        <a href="https://www.instagram.com/unsmperu?utm_source=ig_web_button_share_sheet&igsh=ZDNlZDc0MzIxNw==" target="_blank" rel="noopener noreferrer" aria-label="Instagram UNSM">
                            <img src="../../../imagenes/redes/logo instagram.png" alt="Instagram" width="22" height="22">
                        </a>
                        <a href="https://youtube.com/@unsmperu?si=Lu9kVK7VlDX3qkj6" target="_blank" rel="noopener noreferrer" aria-label="YouTube UNSM">
                            <img src="../../../imagenes/redes/logo yt.png" alt="YouTube" width="22" height="22">
                        </a>
                        <a href="https://x.com/unsmperu" target="_blank" rel="noopener noreferrer" aria-label="X (Twitter) UNSM">
                            <img src="../../../imagenes/redes/logo x.png" alt="X" width="22" height="22">
                        </a>
                        <a href="https://www.tiktok.com/@campus.unsm?is_from_webapp=1&sender_device=pc" target="_blank" rel="noopener noreferrer" aria-label="TikTok UNSM">
                            <img src="../../../imagenes/redes/logo tiktok.png" alt="TikTok" width="22" height="22">
                        </a>
                    </nav>
                </div>
            </div>
        </div>
    </footer>

    <div id="fb-root"></div>
    <script async defer crossorigin="anonymous" src="https://connect.facebook.net/es_LA/sdk.js#xfbml=1&version=v18.0"></script>

    <script src="../../../js/script.js" defer></script>
    <script src="js/scriptAgroIn.js" defer></script>
</body>
</html>
